
//////////////////////////
//Created by LostSinner//
////////////////////////
using System;
using System.Collections;
using System.Collections.Generic;
using Server.Items;
using Server.Targeting;
using Server.ContextMenus;
using Server.Gumps;
using Server.Misc;
using Server.Network;
using Server.Spells;
using Server.Engines.Quests;
using Server.Engines.XmlSpawner2;

namespace Server.Mobiles
{
    //[CorpseName("Corpse Of Merlin")]
    public class Merlin2 : Mobile
    {
        public virtual bool IsInvulnerable { get { return true; } }

        [Constructable]
        public Merlin2()
        {
            Name = "Merlin";
            Title = "Master Magician and Philosopher";
            Body = 400;
            CantWalk = false;
            Hue = 33770;

            int hairHue = 0;
            Blessed = true;

            switch (Utility.Random(1))
            {
                case 0: AddItem(new LongHair(hairHue)); break;
            }
            switch (Utility.Random(1))
            {
                case 0: AddItem(new MediumLongBeard(hairHue)); break;
            }

            AddItem(new Server.Items.HoodedShroudOfShadows(1150));
            AddItem(new Server.Items.Sandals(0));
            AddItem(new Server.Items.FurCape(0));

            GoldNecklace goldnecklace = new GoldNecklace();
            goldnecklace.Hue = 1154;
            goldnecklace.Movable = false;
            AddItem(goldnecklace);

            GoldRing goldring = new GoldRing();
            goldring.Hue = 1154;
            goldring.Movable = false;
            AddItem(goldring);

            Backpack backpack = new Backpack();
            backpack.Hue = 1154;
            backpack.Movable = false;
            AddItem(backpack);
        }

        public Merlin2(Serial serial)
            : base(serial)
        {
        }

        public override void GetContextMenuEntries(Mobile from, List<ContextMenuEntry> list)
        {
            base.GetContextMenuEntries(from, list);
            list.Add(new MerlinEntry(from, this));
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }

        public class MerlinEntry : ContextMenuEntry
        {
            private Mobile m_Mobile;
            private Mobile m_Giver;

            public MerlinEntry(Mobile from, Mobile giver)
                : base(6146, 3)
            {
                m_Mobile = from;
                m_Giver = giver;
            }

            public override void OnClick()
            {
                if (!(m_Mobile is PlayerMobile))
                    return;

                PlayerMobile mobile = (PlayerMobile)m_Mobile;
                {
                    Item x = mobile.Backpack.FindItemByType(typeof(MerlinsBook2));
                    if (x != null)
                    {
                        Item b = mobile.Backpack.FindItemByType(typeof(MerlinsStaff2));
                        if (b != null)
                        {
                           Bag bag = new Bag();
                           bag.DropItem( new BankCheck( 5000 ) );

                				switch ( Utility.Random( 25 ) )
                				{
                					case 0:
                					{
                                 if ( Utility.RandomDouble() < 0.3 )
                                 {
                                    Item blade = new BladeofTorment();
                                    blade.BlessedFor = mobile;
                                    bag.DropItem( new BladeofTorment() );
                                 }
                                 else
                                 {
                                    BaseOuterTorso robe;
                                    
                                    if ( mobile.Female )
                                       robe = new FancyDress();
                                    else
                                       robe = new Robe();
                                       
                                   robe.Hue = Utility.RandomBirdHue();
                                   
                                   if ( robe is Robe )
                                    robe.Name = "Merlin's Robe";
                                   else
                                    robe.Name = "Merlin's Dress";
                                   
                                   switch ( Utility.Random( 8 ) )
                                   {
                                      case 0: robe.Attributes.BonusMana = 10; break;
                                      case 1: robe.Attributes.LowerManaCost = 8; break;
                                      case 2: robe.Attributes.LowerRegCost = 12; break;
                                      case 3: robe.Attributes.Luck = 100; break;
                                      case 4: robe.Attributes.RegenMana = 2; break;
                                      case 5: robe.Attributes.SpellDamage = 15; break;
                                      case 6: robe.Attributes.BonusInt = 5; break;
                                      case 7:
                                      {
                                         robe.Attributes.CastRecovery = 2;
                                         robe.Attributes.CastSpeed = 1;
                                         break;
                                      }
                                   }
                                   
                                   robe.BlessedFor = mobile;
                                   bag.DropItem( robe );
                                 }
                                 
                                 break;
                              }
                					case 1: bag.DropItem( new GuardianCrest() ); break;
                					case 2: bag.DropItem( new MerlinsEarrings() ); break;
                					case 3: bag.DropItem( new WingG() ); break;
                					case 4:
                					{
                                 BaseClothing cloak = new Cloak();
                                 
                                 ((Cloak)cloak).MaxArcaneCharges = 50;
                                 ((Cloak)cloak).CurArcaneCharges = 50;
                                 
                                 cloak.Hue = Utility.RandomBirdHue();
                                 cloak.Name = "Merlin's Cloak";
                                 
                                 switch ( Utility.Random( 8 ) )
                                 {
                                    case 0: cloak.Attributes.BonusMana = 10; break;
                                    case 1: cloak.Attributes.LowerManaCost = 8; break;
                                    case 2: cloak.Attributes.LowerRegCost = 12; break;
                                    case 3: cloak.Attributes.Luck = 100; break;
                                    case 4: cloak.Attributes.RegenMana = 2; break;
                                    case 5: cloak.Attributes.SpellDamage = 15; break;
                                    case 6: cloak.Attributes.BonusInt = 5; break;
                                    case 7:
                                    {
                                       cloak.Attributes.CastRecovery = 2;
                                       cloak.Attributes.CastSpeed = 1;
                                       break;
                                    }
                                 }
                                 
                                 cloak.BlessedFor = mobile;
                                 bag.DropItem( cloak );
                                 break;
                              }
                					case 5: bag.DropItem( new MerlinsAmulet() ); break;
                					default: bag.DropItem( new Tokens( 40 ) ); break;
                				}                         

                           mobile.AddToBackpack( bag );
                            
                            mobile.SendGump(new MerlinsQuestGump9(mobile));
                            b.Delete();
                            x.Delete();
                            if (XmlAttach.FindAttachment(mobile, typeof(MerlinQuest)) == null)
							           XmlAttach.AttachTo(mobile, new MerlinQuest());
                        }
                        else
                        {
                            mobile.PrivateOverheadMessage(MessageType.Regular, 1153, false, "Dej si merlinovu hul a knihu do batohu", mobile.NetState);
                        }
                    }
                    else
                    {
                        mobile.PrivateOverheadMessage(MessageType.Regular, 1153, false, "Zname se?", mobile.NetState);
                    }
                }
            }
        }
    }
}
                    
                   
